#pragma once

#include "global.h"

#define D3DFVF_CUSTOMVERTEX (D3DFVF_XYZ /*| D3DFVF_DIFFUSE*/ |D3DFVF_TEX1)
#define TEXWIDTH 512
#define TEXHEIGHT 256

enum eResolutions
{
	// TV
	RESOLUTION_480I,
	RESOLUTION_480P,
	//RESOLUTION_720I, //FIXME!
	RESOLUTION_720P,
	RESOLUTION_1080I,
	RESOLUTION_1080P
};
#define RESOLUTION_MIN		RESOLUTION_480I
#define RESOLUTION_MAX		RESOLUTION_720P

typedef struct CustomVertex
{
    float x, y, z;
    //dword color;
	float u, v;
}CustomVertex;


class D3D
{
public:
	D3D(void);
	~D3D(void);

	bool Create(); //Device creation
	bool CreateVertexBuffer(dword Length);
	//bool CreateSpriteInterface();
	bool CreateTexture(dword id, dword width, dword height);

	void BeginRender();
	void EndRender();

	void RenderPoints();

public:
	Direct3D	*m_pD3D; //D3D object
	D3DDevice	*m_pD3DDevice; //D3D device
	D3DVertexBuffer *m_pVertexBuffer; //D3D vertex buffer
	//LPD3DXSPRITE	m_pSprite; //Sprite object
	D3DTexture		*m_pTexture[256];//Texture for the sprite

	DWORD m_dwWidth;
	DWORD m_dwHeight;

private:
};

extern D3D g_d3d;
extern HRESULT g_hResult;
